# Emergent App - HTML/CSS/JavaScript Versiyonu

## 📋 İçerik

Bu proje, Emergent uygulamasının saf HTML, CSS ve JavaScript ile yazılmış statik versiyonudur. Backend gerektirmez ve her modern tarayıcıda çalışır.

## 📁 Dosya Yapısı

```
html_version/
├── index.html          # Ana HTML dosyası
├── styles.css          # Tüm CSS stilleri
├── script.js           # JavaScript fonksiyonları
└── README.md           # Bu dosya
```

## 🚀 Nasıl Çalıştırılır

### Yöntem 1: Doğrudan Tarayıcıda Açma
1. `index.html` dosyasına çift tıklayın
2. Dosya varsayılan tarayıcınızda açılacaktır

### Yöntem 2: Yerel Sunucu ile (Önerilen)

**Python 3 ile:**
```bash
python -m http.server 8000
```
Sonra tarayıcınızda şu adrese gidin: `http://localhost:8000`

**Node.js ile (http-server):**
```bash
npx http-server -p 8000
```
Sonra tarayıcınızda şu adrese gidin: `http://localhost:8000`

### Yöntem 3: VS Code Live Server
1. VS Code'da dosyaları açın
2. Live Server eklentisini yükleyin
3. `index.html` üzerinde sağ tıklayın ve "Open with Live Server" seçin

## ✨ Özellikler

### Ana Sayfa
- Emergent logosu ve hoş geldin mesajı
- "Status Kontrol Sayfası" butonuyla yönlendirme
- Karanlık tema tasarımı

### Status Kontrol Yönetimi
- **Yeni Status Kontrolü Oluşturma:** Client ismi ile yeni kayıt oluşturabilirsiniz
- **Status Listesi:** Tüm oluşturulmuş status kontrollerini görüntüleyebilirsiniz
- **Otomatik Kaydetme:** Veriler tarayıcı LocalStorage'ında saklanır
- **Gerçek Zamanlı Güncelleme:** Yeni kayıt eklendiğinde liste otomatik güncellenir

## 💾 Veri Saklama

Uygulama, tüm verileri tarayıcının **LocalStorage**'ında saklar. Bu sayede:
- Backend sunucusuna ihtiyaç yoktur
- Veriler tarayıcıda yerel olarak saklanır
- Sayfa yenilendiğinde veriler kaybolmaz
- Her tarayıcı kendi verilerini tutar

**Not:** LocalStorage temizlenirse veya farklı bir tarayıcı kullanılırsa veriler kaybolur.

## 🎨 Tasarım Özellikleri

- Responsive tasarım (mobil uyumlu)
- Karanlık tema (#0f0f10 arka plan)
- Hover efektleri ve animasyonlar
- Modern UI/UX
- Temiz ve profesyonel görünüm

## 🔧 Özelleştirme

### Renkleri Değiştirme
`styles.css` dosyasında ana renkleri bulabilirsiniz:
- Ana arka plan: `#0f0f10`
- Vurgu rengi: `#61dafb`
- Kart arka planı: `#1a1a1e`

### Yeni Özellik Ekleme
1. `index.html`: HTML yapısını ekleyin
2. `styles.css`: Gerekli stilleri ekleyin
3. `script.js`: JavaScript fonksiyonlarını ekleyin

## 📱 Tarayıcı Desteği

- ✅ Chrome (son 2 versiyon)
- ✅ Firefox (son 2 versiyon)
- ✅ Safari (son 2 versiyon)
- ✅ Edge (son 2 versiyon)
- ✅ Opera (son 2 versiyon)

## 🐛 Demo Veri Ekleme

Test için demo veri eklemek isterseniz, tarayıcı konsolunda şu komutu çalıştırın:
```javascript
addDemoData();
```

## 📦 Dağıtım

Bu statik dosyaları şu platformlarda ücretsiz yayınlayabilirsiniz:
- GitHub Pages
- Netlify
- Vercel
- Cloudflare Pages
- Firebase Hosting

## 🔒 Güvenlik

- XSS koruması için tüm kullanıcı girdileri HTML escape edilir
- LocalStorage verileri tarayıcıda güvenli şekilde saklanır
- Hassas bilgi saklanmamalıdır

## 📝 Lisans

Bu proje açık kaynaklıdır ve özgürce kullanılabilir.

## 💡 İpuçları

1. **Veri Yedekleme:** LocalStorage verilerinizi yedeklemek için tarayıcı geliştirici araçlarını kullanın
2. **Temizleme:** LocalStorage'ı temizlemek için tarayıcı ayarlarından önbelleği temizleyin
3. **Geliştirme:** Tarayıcı geliştirici araçları (F12) ile kodu inceleyebilirsiniz

## 📞 Destek

Sorularınız için: https://emergent.sh

---

**Not:** Bu HTML versiyonu, orijinal React + FastAPI + MongoDB versiyonunun basitleştirilmiş bir kopyasıdır. Production kullanımı için backend entegrasyonlu versiyonu tercih edin.